import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class obstacle
{
	//Initialize the images
	Image objCone = Toolkit.getDefaultToolkit().getImage("obj_cone.gif");
	Image objPothole = Toolkit.getDefaultToolkit().getImage("obj_pothole.gif");
	Image objTurtle = Toolkit.getDefaultToolkit().getImage("obj_turtle.gif");
	Image objDeer = Toolkit.getDefaultToolkit().getImage("obj_deer.gif");

	Image objRock = Toolkit.getDefaultToolkit().getImage("obj_rock.gif");
	Image objTrafhorse = Toolkit.getDefaultToolkit().getImage("obj_trafhorse.gif");
	Image objShrub = Toolkit.getDefaultToolkit().getImage("obj_shrub.gif");
	Image objMud = Toolkit.getDefaultToolkit().getImage("obj_mud.gif");

	Image objFrog = Toolkit.getDefaultToolkit().getImage("obj_frog.gif");
	Image objHippo = Toolkit.getDefaultToolkit().getImage("obj_hippo.gif");
	Image objMonkey = Toolkit.getDefaultToolkit().getImage("obj_monkey.gif");
	Image objCroc = Toolkit.getDefaultToolkit().getImage("obj_croc.gif");	

	//Initialize the Arrays
	int arraySize = 200;
	Image[] objectsImage = new Image[arraySize];
	int[] objectsImageNumber = new int[arraySize];
	int[] objectsPosX = new int[arraySize];
	int[] objectsPosY = new int[arraySize];
	int[] objectsSizeX = new int[arraySize];
	int[] objectsSizeY = new int[arraySize];

	int trackType = 1;

	public obstacle(int inputTrackType)
	{
		trackType = inputTrackType;
		generateObstacles(trackType);
	}
	
	public void importObjects()
	{
		for (int c=0; c<objectsImageNumber.length; c++)
		{
			switch (objectsImageNumber[c])
			{
				case 1:
					objectsImage[c] = objCone;
					break;
				case 2:
					objectsImage[c] = objPothole;
					break;
				case 3:
					objectsImage[c] = objTurtle;
					break;
				case 4:
					objectsImage[c] = objDeer;
					break;
				case 5:
					objectsImage[c] = objRock;
					break;
				case 6:
					objectsImage[c] = objTrafhorse;
					break;
				case 7:
					objectsImage[c] = objShrub;
					break;
				case 8:
					objectsImage[c] = objMud;
					break;
				case 9:
					objectsImage[c] = objFrog;
					break;
				case 10:
					objectsImage[c] = objHippo;
					break;
				case 11:
					objectsImage[c] = objMonkey;
					break;
				case 12:
					objectsImage[c] = objCroc;
					break;		

			}
		}
	}
	
	public void clearArrays()
	{
		for (int a=0; a<objectsImage.length; a++)
		{
			objectsImage[a] = objCone;
			objectsImageNumber[a] = 1;
			objectsPosX[a]=0;
			objectsPosY[a]=0;
			objectsSizeX[a]=0;
			objectsSizeY[a]=0;
		}
	}
	
	public void generateObstacles(int inputTrackType)
	{
		trackType = inputTrackType;
		clearArrays();
		for (int b=0; b<objectsImage.length; b++)
		{
			double rtype = 0;
			double rx = 0;
			double ry = 0;
			
			int type = 0;
			int PosX = 0;
			int PosY = 0;
			
			rtype = Math.random();
			rx = Math.random();
			ry= Math.random();
			
			type = (int) (rtype * 4f);
			PosX = (int) (rx * 600f);
			PosY = (int) (ry * -10000f);
			//System.out.println(b+","+rndx  +","+rndy);
			
			switch (inputTrackType)
			{
				case 1:
					//Road
					switch (type)
					{
						case 0:
							objectsImage[b] = objCone;
							objectsImageNumber[b] = 1;
							objectsSizeX[b] = 33;
							objectsSizeY[b] = 36;
							break;
						case 1:
							objectsImage[b] = objPothole;
							objectsImageNumber[b] = 2;
							objectsSizeX[b] = 34;
							objectsSizeY[b] = 42;
							break;
						case 2:
							objectsImage[b] = objTurtle;
							objectsImageNumber[b] = 3;
							objectsSizeX[b] = 33;
							objectsSizeY[b] = 43;
							break;
						case 3:
							objectsImage[b] = objDeer;
							objectsImageNumber[b] = 4;
							objectsSizeX[b] = 79;
							objectsSizeY[b] = 58;
							break;
					}
					break;
				case 2:
					//Dirt
					switch (type)
					{
						case 0:
							objectsImage[b] = objRock;
							objectsImageNumber[b] = 5;
							objectsSizeX[b] = 39;
							objectsSizeY[b] = 40;
							break;
						case 1:
							objectsImage[b] = objTrafhorse;
							objectsImageNumber[b] = 6;
							objectsSizeX[b] = 62;
							objectsSizeY[b] = 68;
							break;
						case 2:
							objectsImage[b] = objShrub;
							objectsImageNumber[b] = 7;
							objectsSizeX[b] = 78;
							objectsSizeY[b] = 73;
							break;
						case 3:
							objectsImage[b] = objMud;
							objectsImageNumber[b] = 8;
							objectsSizeX[b] = 59;
							objectsSizeY[b] = 66;
							break;
					}
					break;
				case 3:
					//Jungle
					switch (type)
					{
						case 0:
							objectsImage[b] = objFrog;
							objectsImageNumber[b] = 9;
							objectsSizeX[b] = 85;
							objectsSizeY[b] = 84;
							break;
						case 1:
							objectsImage[b] = objHippo;
							objectsImageNumber[b] = 10;
							objectsSizeX[b] = 79;
							objectsSizeY[b] = 183;
							break;
						case 2:
							objectsImage[b] = objMonkey;
							objectsImageNumber[b] = 11;
							objectsSizeX[b] = 76;
							objectsSizeY[b] = 69;
							break;
						case 3:
							objectsImage[b] = objCroc;
							objectsImageNumber[b] = 12;
							objectsSizeX[b] = 79;
							objectsSizeY[b] = 215;
							break;
					}
					break;
			}		


					
			
			objectsPosX[b] = PosX;
			objectsPosY[b] = PosY;
 		}
	}
}